/*
 * 作成日: 2008/08/05
 * 著作権: Copyright (c) 2005 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc;

import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.ext.s2jdbc.util.CommentUtil;
import zigen.plugin.db.ui.internal.Column;


public class CodeCreatorUtil {
	
	private static final String line_sep = System.getProperty("line.separator"); //$NON-NLS-1$
	
	public static String propertyString(String accessModifiers, String type, String property) {
		StringBuffer sb = new StringBuffer();
		if (accessModifiers != null && !"".equals(accessModifiers)) { //$NON-NLS-1$
			sb.append(accessModifiers + " "); //$NON-NLS-1$
		}
		sb.append(type + " "); //$NON-NLS-1$
		sb.append(property + ";"); //$NON-NLS-1$
		return sb.toString();
	}
	
	// Getterメソッド文字列の取得
	public static String getterString(String propertyName) {
		StringBuffer sb = new StringBuffer();
		sb.append("get"); //$NON-NLS-1$
		sb.append(propertyName.substring(0, 1).toUpperCase());
		// 2文字から小文字化は行わない
		sb.append(propertyName.substring(1, propertyName.length()));
		
		return sb.toString();
	}
	
	// Setterメソッド文字列の取得
	public static String setterString(String propertyName) {
		StringBuffer sb = new StringBuffer();
		sb.append("set"); //$NON-NLS-1$
		sb.append(propertyName.substring(0, 1).toUpperCase());
		// 2文字から小文字化は行わない
		sb.append(propertyName.substring(1, propertyName.length()));
		return sb.toString();
	}
	
	public static String toStringString(String className, String[] properties) {
		StringBuffer sb = new StringBuffer();
		
		sb.append("\t" + "public String toString(){" + line_sep); //$NON-NLS-1$ //$NON-NLS-2$
		sb.append("\t" + "\t" + "StringBuffer buffer = new StringBuffer();" + line_sep); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		sb.append("\t" + "\t" + "buffer.append(\"[" + className + ":\");" + line_sep); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		
		for (int i = 0; i < properties.length; i++) {
			String property = properties[i];
			sb.append("\t" + "\t" + "buffer.append(\" " + property + ": \");" + line_sep); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			sb.append("\t" + "\t" + "buffer.append(" + property + ");" + line_sep); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		}
		
		sb.append("\t" + "\t" + "buffer.append(\"]\");" + line_sep); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		sb.append("\t" + "\t" + "return buffer.toString();" + line_sep); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		sb.append("\t" + "}" + line_sep); //$NON-NLS-1$ //$NON-NLS-2$
		
		return sb.toString();
		
	}
	
	/**
	 * プロティのコメント用名前の取得
	 * 
	 * @return
	 */
	public static String getLogicalColumnLabel(Column col) {
		TableColumn column = col.getColumn();
		
		StringBuffer sb = new StringBuffer();
		
		String remarks = column.getRemarks();
		if (remarks != null && remarks.length() > 0) {
			
			// sb.append(column.getRemarks());
			sb.append(CommentUtil.removeAnnotation(remarks));
			

		} else {
			sb.append(column.getColumnName());
		}
		sb.append("：");
		sb.append(column.getTypeName().toLowerCase());
		
		if (column.getDecimalDigits() == 0) {
			sb.append("(" + column.getColumnSize() + ")");
		} else {
			sb.append("(" + column.getColumnSize() + "," + column.getDecimalDigits() + ")");
		}
		
		if (col.hasPrimaryKey()) {
			sb.append(" <Primary Key>");
		}
		// if(fkColumns != null && fkColumns.length>0){ sb.append(" <Foreign
		// Key>");}
		
		return sb.toString();
		
	}
}
